//Experiment-5
// windows 8.1 - 64-Bit
//Scilab - 6.0.0


//Aim : Design of a small single phase transformer using SCILAB coding
//Data: Design a small single phase transformer for given ratings

clc
clear all

// Following data is to be taken form the user
Vo=input('Enter value of output voltage of transformer') // output voltage of the transformer (in the range of 5 - 12 volts)
Io=input('Enter value of output current of transformer') // output current of the transformer (in the range of 2 - 5 Amp.)
Vi=input('Enter value of input voltage of transformer') // input voltage of the transformer (in the range of 110 - 230 volts)
f=input('Enter value of operating frequency in Hz') // operating frequency of the transformer (in the range of 50 - 60 Hz)

// Assuming following

n = 0.9   // assuming 90% eficiency
Et = 9 // emf per turn
Bm = 1 // maximum flux density
Ks = 0.9 // stacking factor
del = 2.3 // current density in conductor

// Actual Calculations begin

P = Vo*Io // output rating of transformer
phi_m = (1/(4.44*f*Et)) // maximum flux in the core
Ac = phi_m/Bm // net area of core
Ag = Ac/Ks // gross core area
A = sqrt(Ag) // width of central limb assuming square cross section
Np = Vi*Et // No.of turns in primary
Ns = ceil(1.05*Vo*Et) // No.of turns in secondary
Ip = P/(n*Vi) // Current in primary winding
Ap = Ip / del // corss sectional area of bare primary conductor
dp = sqrt(4*Ap/%pi) // diameter of bare primary conductor
dpi = dp+0.3 // diameter of insulated primary conductor
Api = (%pi*dpi^2)/4 // corss sectional area of insulated primary conductor
As = Io / del // corss sectional area of bare secondary conductor
ds = 0.2+sqrt(4*As/%pi) // diameter of bare secondary conductor
dsi = ds+0.1 // diameter of insulated secondary conductor
Asi = (%pi*dsi^2)/4 // corss sectional area of insulated secondary conductor
sfp = 0.8*(dp/dpi)^2 // space factor of primary winding 
Awp = ceil(Np*Api/sfp) // window area for primary winding 
sfs = 0.8*(ds/dsi)^2 // space factor of secondary winding 
Aws = ceil(Ns*Asi/sfs) // window area for secondary winding 
Aw = 1.2*(Aws+Awp) // gross window area required

mprintf('No. of urns required in Primary is %d',Np)
mprintf('\n')
mprintf('No. of urns required in Secondary is %d',Ns)
mprintf('\n')
mprintf('Power Rating of the transformer is %d VA',P)
mprintf('\n')
mprintf('Diameter of insulated primary conductor is %f mm',dpi)
mprintf('\n')
mprintf('Diameter of insulated secondary conductor is %f mm',dsi)
mprintf('\n')
mprintf('Gross window area required is %d mm^2',Aw)
